Drop Database if exists AIRSATZ;
CREATE DATABASE AIRSATZ;
use AIRSATZ;


SET default_storage_engine=INNODB;
SET autocommit = 0;
SET SQL_SAFE_UPDATES = 0;

/* Création des tables de référence*/


CREATE TABLE aeroport ( 
codes CHAR(3), 
pays VARCHAR(50), 
villes VARCHAR(50),
 nbpisti INT unsigned not null,
 constraint pk_aeroport primary key (codes) );

 CREATE TABLE fabricant ( 
fabricants  VARCHAR(50),
pays VARCHAR(50), 
anneecreationi YEAR,
 rangmondiali INT unsigned not null,      /* rang mondial en CA */
 constraint pk_fabricant primary key (fabricants ));

 CREATE TABLE typeavion ( 
 idtypeavioni INT(10)  NOT NULL AUTO_INCREMENT,
fabricants VARCHAR(50),
modeles VARCHAR(50), 
versions VARCHAR(50),
 nbplacei INT unsigned not null,      /* nombre de place */
 nbmoteuri INT unsigned not null,		/* nombre de moteurs */
 constraint pk_typeavion primary key (idtypeavioni),
 constraint fk_fabricant FOREIGN KEY  (fabricants) REFERENCES fabricant (fabricants));


CREATE TABLE avion ( 
idavioni INT(10)  NOT NULL AUTO_INCREMENT,
anneed YEAR,			/* année de mise en service */
daterevisiond DATE, 	/* date de dernière révision */
idtypeavioni INT, 
 constraint pk_avion primary key (idavioni) ,
 constraint fk_typeavion FOREIGN KEY  (idtypeavioni) REFERENCES typeavion (idtypeavioni) 
);


CREATE TABLE pilote ( 
idpiloti INT(8)  NOT NULL AUTO_INCREMENT,
noms VARCHAR(50), 
prenoms VARCHAR(50), 
datenaissanced DATE, 
sexec CHAR(1), 
datelicenced DATE,
 constraint pk_pilote primary key (idpiloti) 
);


CREATE TABLE piloteaccreditation ( 
idpiloti INT(10) ,
idtypeavioni INT(10),
datefind DATE, 
 constraint pk_piloteaccreditation primary key (idpiloti, idtypeavioni)  
);


CREATE TABLE vol ( 
numvoli INT(10)  NOT NULL AUTO_INCREMENT,
aeroportdeparts CHAR(3),
aeroportarrives CHAR(3),
datevols DATE, 
heuredeparth TIME,
heurearriveeh TIME,
idpiloti INT(10) ,
idavioni INT(10) ,
 constraint pk_vol primary key (numvoli) ,
 constraint fk_aeroportdepart FOREIGN KEY  (aeroportdeparts) REFERENCES aeroport (codes),
 constraint fk_aeroportarrvee FOREIGN KEY  (aeroportarrives) REFERENCES aeroport (codes),
 constraint fk_pilote FOREIGN KEY  (idpiloti) REFERENCES pilote (idpiloti),
 constraint fk_avion FOREIGN KEY  (idavioni) REFERENCES avion (idavioni)
);

create table aeroporthomologation (
codeaeroports Char(3),
idtypeavioni int(10),
primary key pk_aeroporthomologation (codeaeroports,idtypeavioni)
);

select * from vol where heurearriveeh between '19:00:00' and '22:00:00';

select aeroportdeparts,aeroportarrives,modeles,versions from vol join avion on vol.idavioni = avion.idavioni 
join typeavion on avion.idtypeavioni = typeavion.idtypeavioni join fabricant on typeavion.fabricants =fabricant.fabricants 
where pays='USA';

select aeroportdeparts,aeroportarrives,pilote.idpiloti,noms,prenoms,datenaissanced,sexec,datelicenced from vol join pilote 
on vol.idpiloti =pilote.idpiloti where datenaissanced >'1990-01-01';

/*select v.numvoli,v.datevoli,v.aeroportdeparts, from vol v, pilote p where v.idpiloti = p.idpiloti AND p.datenaissanced > une date;*/

select pilote.noms,modeles from pilote join piloteaccreditation on pilote.idpiloti = piloteaccreditation.idpiloti 
join avion on piloteaccreditation.idtypeavioni = avion.idtypeavioni join typeavion
 on avion.idtypeavioni = typeavion.idtypeavioni
where noms like '%a%';

select pays,AVG(nbpisti) from aeroport group by pays having AVG(nbpisti)>3 order by pays;
select idavioni,fabricants,min(anneed) from avion join typeavion on avion.idtypeavioni = typeavion.idtypeavioni group by fabricants;

create user "hugo"@"localhost" identified by "hugo";
grant usage on airsatz.* to "hugo"@"localhost";
grant select (idpiloti,datenaissanced,sexec) on airsatz.pilote to "hugo"@"localhost";
grant update (datelicenced) on airsatz.pilote to "hugo"@"localhost";
/* synthaxe pour le grant select d'une vue: grant select on airsatz.vuepilote to "hugo"@"localhost"; */

/* création rôle pour utilisateur */
drop user 'userselect'@'localhost'; 
drop role 'role_select';
create user "userselect"@"localhost" identified by "user";
create role "role_select";
grant usage on airsatz.* to "role_select";
grant select on airsatz.pilote to "role_select";
grant "role_select" to "userselect"@"localhost";
set default role all to 'userselect'@'localhost';
grant select (anneed,daterevisiond) on airsatz.avion to 'userselect'@'localhost';

